#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_PatientOrder : BaseTest 
	{
		private DataTable _dtPatientOrder;
		private DataTable _dtVbecsOrder;
		private DataTable _dtOrderedTest;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtPatientOrder = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PatientOrder WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", false);
				if (this._dtPatientOrder.Rows.Count == 0)
				{
					DataCreator.CreateCrossmatchedBloodUnitTestData();
					this._dtPatientOrder = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PatientOrder WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				}

				//*VbecsOrderNumber ********************************************
				this._dtVbecsOrder = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM VbecsOrder ORDER BY LastUpdateDate DESC", false);
				if (this._dtVbecsOrder.Rows.Count == 0)
				{
					UnitTestUtil.RunSQL("spGetNextVbecsOrderNumber '" + Common.LogonUser.LogonUserName + "'," + ((int)Common.UpdateFunction.UnitTests).ToString());
					this._dtVbecsOrder = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM VbecsOrder ORDER BY LastUpdateDate DESC", true);
				}

				//*OrderedTest ********************************************
				this._dtOrderedTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedTest WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}

		}

		[Test]
		public void GetOrderUrgencyList_Pass()
		{
			DataTable dtTest = DAL.PatientOrder.GetOrderUrgencyList();

			Assert.IsTrue(dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderUrgency.OrderUrgencyCode), TABLES.OrderUrgency.OrderUrgencyCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderUrgency.OrderUrgencyText), TABLES.OrderUrgency.OrderUrgencyText);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderUrgencyList_Fail()
		{
		}

		[Test]
		public void GetOrderSearchDetails_Pass()
		{
			System.DateTime startDate = System.DateTime.Now.AddYears(-1);
			System.DateTime endDate = System.DateTime.Now.AddYears(1);

			DataTable dtTest = DAL.PatientOrder.GetOrderSearchDetails(startDate, endDate, "1","1","S");

			Assert.IsTrue(dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(42, dtTest.Columns.Count, "Columns.Count");
		}

		[Test]
		public void GetOrderSearchDetails_Fail()
		{
			System.DateTime startDate = System.DateTime.Now.AddYears(1);
			System.DateTime endDate = System.DateTime.Now.AddYears(-1);

			DataTable dtTest = DAL.PatientOrder.GetOrderSearchDetails(startDate, endDate, "1","1","S");

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetPatientOrder_Pass()
		{
			System.Text.StringBuilder sb=new System.Text.StringBuilder();
			sb.Append(" SELECT ");
			sb.Append("	TOP 1 PO.PatientOrderGuid ");
			sb.Append(" FROM PatientOrder PO ");
			sb.Append("	JOIN PatientTreatment PT ON PO.PatientTreatmentGUID = PT.PatientTreatmentGUID ");
			sb.Append("	JOIN PatientSpecimen PS	ON PT.PatientGUID = PS.PatientGUID ");
			sb.Append("	JOIN OrderedTest OT ON PS.PatientSpecimenGUID = OT.PatientSpecimenGUID ");
			sb.Append(" WHERE PO.DivisionCode= '"+UnitTestConfig.TestDivisionCode +"' ");
			
			DataTable dtPO=UnitTestUtil.RunSQLGetDataTable(sb.ToString(), true);

			Guid unitGuid = (Guid)dtPO.Rows[0][TABLES.PatientOrder.PatientOrderGuid];

			DataTable dtTest = DAL.PatientOrder.GetPatientOrder(unitGuid);

			Assert.IsTrue(dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(26, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.PatientOrderGuid), TABLES.PatientOrder.PatientOrderGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientGuid), TABLES.Patient.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientTreatmentGuid), TABLES.PatientTreatment.PatientTreatmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderGroupNumber), TABLES.PatientOrder.OrderGroupNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderPlacedDatetime), TABLES.PatientOrder.OrderPlacedDatetime);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderReceivedDatetime), TABLES.PatientOrder.OrderReceivedDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.LabOrderNumber), TABLES.OrderedTest.LabOrderNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderId), TABLES.PatientOrder.OrderingProviderId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderLastName), TABLES.PatientOrder.OrderingProviderLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderFirstName), TABLES.PatientOrder.OrderingProviderFirstName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderMiddleInitial), TABLES.PatientOrder.OrderingProviderMiddleInitial);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingHospitalLocation), TABLES.PatientOrder.OrderingHospitalLocation);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderEnteredById), TABLES.PatientOrder.OrderEnteredById);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderEnteredByLastName), TABLES.PatientOrder.OrderEnteredByLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderEnteredByFirstName), TABLES.PatientOrder.OrderEnteredByFirstName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderEnteredByMiddleInitial), TABLES.PatientOrder.OrderEnteredByMiddleInitial);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.RequestReason), TABLES.PatientOrder.RequestReason);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.SpecimenRequiredIndicator), TABLES.OrderedTest.SpecimenRequiredIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderComments), TABLES.PatientOrder.OrderComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.InformedConsentIndicator), TABLES.PatientOrder.InformedConsentIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.SurgeryName), TABLES.PatientOrder.SurgeryName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.DivisionCode), TABLES.PatientOrder.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.LastUpdateDate), TABLES.PatientOrder.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.LastUpdateUser), TABLES.PatientOrder.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.RowVersion), TABLES.PatientOrder.RowVersion);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TreatingSpecialty.TreatingSpecialtyName), TABLES.TreatingSpecialty.TreatingSpecialtyName);
		}

		[Test]
		public void GetPatientOrder_Fail()
		{
			DataTable dtTest = DAL.PatientOrder.GetPatientOrder(Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetNextVbecsOrderNumber_Pass()
		{
			int lastOrder = System.Convert.ToInt32(this._dtVbecsOrder.Rows[0][Common.VbecsTables.VbecsOrder.VbecsOrderNumber]);

			DataTable dtTest = DAL.PatientOrder.GetNextVbecsOrderNumber();

			int newOrder = System.Convert.ToInt32(dtTest.Rows[0][Common.VbecsTables.VbecsOrder.VbecsOrderNumber]);

			Assert.IsTrue(newOrder > lastOrder);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetNextVbecsOrderNumber_Fail()
		{
		}

	

		

		[Test]
		public void PrintPatientOrderAlert_Pass()
		{
			Guid unitGuid = (Guid)this._dtPatientOrder.Rows[0][TABLES.PatientOrder.PatientOrderGuid];
			string cprsNumber = "0";

			DataSet dsTest = DAL.PatientOrder.PrintPatientOrderAlert(unitGuid, cprsNumber, UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(3, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(13, dsTest.Tables[0].Columns.Count, "Tables[0].Columns.Count");
			Assert.AreEqual(11, dsTest.Tables[1].Columns.Count, "Tables[1].Columns.Count");
			Assert.AreEqual(12, dsTest.Tables[2].Columns.Count, "Tables[2].Columns.Count");
		}

		[Test]
		public void PrintPatientOrderAlert_Fail()
		{
			Guid unitGuid = Guid.NewGuid();
			string cprsNumber = "0";

			DataSet dsTest = DAL.PatientOrder.PrintPatientOrderAlert(unitGuid, cprsNumber, UnitTestConfig.TestDivisionCode);
 
			Assert.AreEqual(3, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Tables[0].Columns.Count");
			Assert.AreEqual(0, dsTest.Tables[1].Rows.Count, "Tables[1].Columns.Count");
			Assert.AreEqual(0, dsTest.Tables[2].Rows.Count, "Tables[2].Columns.Count");
		}

		[Test]
		public void GetReflexTestsForOrder_Pass()
		{
			Guid orderGuid = (Guid)this._dtOrderedTest.Rows[0][TABLES.OrderedTest.OrderedTestGuid];

			DataTable dtTest = DAL.PatientOrder.GetReflexTestsForOrder(orderGuid);

			Assert.IsTrue(dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(14, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.PatientOrderGuid), TABLES.PatientOrder.PatientOrderGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderReceivedDatetime), TABLES.PatientOrder.OrderReceivedDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.RequiredResultsDate), TABLES.OrderedTest.RequiredResultsDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderPlacedDatetime), TABLES.PatientOrder.OrderPlacedDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderLastName), TABLES.PatientOrder.OrderingProviderLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderFirstName), TABLES.PatientOrder.OrderingProviderFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderMiddleInitial), TABLES.PatientOrder.OrderingProviderMiddleInitial);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderEnteredById), TABLES.PatientOrder.OrderEnteredById);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderEnteredByLastName), TABLES.PatientOrder.OrderEnteredByLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderEnteredByFirstName), TABLES.PatientOrder.OrderEnteredByFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestName), TABLES.OrderableTest.OrderableTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.OrderedTestGuid), TABLES.OrderedTest.OrderedTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.OrderableTestId), TABLES.OrderedTest.OrderableTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.PatientSpecimenGuid), TABLES.OrderedTest.PatientSpecimenGuid);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetReflexTestsForOrder_Fail()
		{
			DAL.PatientOrder.GetReflexTestsForOrder(Guid.Empty);
		}

	}
}
#endif
